<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use yii\widgets\MaskedInput;

$this->title = 'Регистрация - Коммуналка';
$this->registerCssFile('@web/css/style.css');
$this->registerCssFile('@web/css/adaptive.css');
?>

<div class="auth-container">
    <div class="auth-card">
        <div class="auth-header">
            <span class="auth-logo">💡 Коммуналка</span>
            <h1 class="auth-title">Создание аккаунта</h1>
            <p class="auth-subtitle">Заполните все поля для регистрации в системе</p>
        </div>

        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-error">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>

        <?php $form = ActiveForm::begin([
            'id' => 'register-form',
            'options' => ['class' => 'auth-form'],
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'control-label'],
                'errorOptions' => ['class' => 'help-block'],
            ],
        ]); ?>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'full_name')->textInput([
                    'autofocus' => true,
                    'placeholder' => 'Иванов Иван Иванович',
                    'class' => 'form-control'
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'phone')->widget(MaskedInput::class, [
                    'mask' => '8(999)999-99-99',
                    'options' => [
                        'class' => 'form-control',
                        'placeholder' => '8(999)123-45-67'
                    ]
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'email')->textInput([
                    'placeholder' => 'example@mail.ru',
                    'class' => 'form-control',
                    'type' => 'email'
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'address')->textarea([
                    'rows' => 3,
                    'placeholder' => 'г. Москва, ул. Примерная, д. 1, кв. 1',
                    'class' => 'form-control'
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'residents_count')->textInput([
                    'type' => 'number',
                    'min' => '1',
                    'placeholder' => '3',
                    'class' => 'form-control'
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'password')->passwordInput([
                    'placeholder' => 'Минимум 10 символов',
                    'class' => 'form-control'
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'password_repeat')->passwordInput([
                    'placeholder' => 'Повторите пароль',
                    'class' => 'form-control'
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <div class="agree-terms">
                    <?= $form->field($model, 'agree_terms', [
                        'template' => "{input}\n{label}\n{error}",
                        'labelOptions' => ['style' => 'padding-left: 0;']
                    ])->checkbox([], false) ?>
                    <label for="registerform-agreeterms">
                        Я соглашаюсь с <a href="#" onclick="alert('Правила использования сервиса...')">правилами регистрации</a> и обработкой персональных данных
                    </label>
                </div>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <div class="form-group">
                    <?= Html::submitButton('Создать пользователя', [
                        'class' => 'auth-btn btn-primary',
                        'name' => 'register-button'
                    ]) ?>
                </div>
            </div>
        </div>

        <?php ActiveForm::end(); ?>

        <div class="auth-links">
            <p>Уже есть аккаунт? <?= Html::a('Войти в систему', ['site/login']) ?></p>
        </div>
    </div>
</div>