<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use yii\widgets\MaskedInput;

$this->title = 'Авторизация - Коммуналка';
$this->registerCssFile('@web/css/style.css');
$this->registerCssFile('@web/css/adaptive.css');
?>

<div class="auth-container">
    <div class="auth-card">
        <div class="auth-header">
            <span class="auth-logo">💡 Коммуналка</span>
            <h1 class="auth-title">Вход в систему</h1>
            <p class="auth-subtitle">Введите ваш телефон и пароль для входа</p>
        </div>

        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-error">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>

        <?php $form = ActiveForm::begin([
            'id' => 'login-form',
            'options' => ['class' => 'auth-form'],
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'control-label'],
                'errorOptions' => ['class' => 'help-block'],
            ],
        ]); ?>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'phone')->widget(MaskedInput::class, [
                    'mask' => '8(999)999-99-99',
                    'options' => [
                        'class' => 'form-control',
                        'placeholder' => '8(999)123-45-67',
                        'autofocus' => true
                    ]
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'password')->passwordInput([
                    'placeholder' => 'Введите ваш пароль',
                    'class' => 'form-control'
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <?= $form->field($model, 'rememberMe')->checkbox([
                    'template' => "<div class=\"agree-terms\">{input} {label}</div>\n<div>{error}</div>",
                ]) ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-col">
                <div class="form-group">
                    <?= Html::submitButton('Войти', [
                        'class' => 'auth-btn btn-primary',
                        'name' => 'login-button'
                    ]) ?>
                </div>
            </div>
        </div>

        <?php ActiveForm::end(); ?>

        <div class="auth-links">
            <p>Еще не зарегистрированы? <?= Html::a('Регистрация', ['site/register']) ?></p>
        </div>

        <div class="admin-info">
            <p class="admin-info-text">
                Тестовый администратор:<br>
                Телефон: <strong>8(000)000-00-00</strong><br>
                Пароль: <strong>kommunalshik</strong>
            </p>
        </div>
    </div>
</div>