<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Портал передачи показаний - Коммунальные услуги';
?>
<div class="site-index">
    <!-- Герой секция -->
    <section class="hero-section">
        <div class="hero-background">
            <div class="hero-content">
                <div class="hero-logo">
                    <div class="logo-icon">🏠</div>
                    <h1 class="logo-title">Коммуналка-Онлайн</h1>
                    <div class="logo-subtitle">Цифровой портал передачи показаний</div>
                </div>
                <div class="hero-actions">
                    <?php if (Yii::$app->user->isGuest): ?>
                        <?= Html::a('🔐 Войти в систему', ['/site/login'], ['class' => 'btn btn-primary btn-large']) ?>
                        <?= Html::a('📝 Зарегистрироваться', ['/site/signup'], ['class' => 'btn btn-outline btn-large']) ?>
                    <?php else: ?>
                        <?= Html::a('📤 Передать показания', ['/readings/create'], ['class' => 'btn btn-primary btn-large']) ?>
                        <?= Html::a('📊 Мои показания', ['/readings/index'], ['class' => 'btn btn-outline btn-large']) ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Приветственная секция -->
    <section class="welcome-section">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Добро пожаловать на портал!</h2>
                <p class="section-subtitle">Простая и удобная передача показаний счетчиков</p>
            </div>
            
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">⚡</div>
                    <h3 class="feature-title">Электроэнергия</h3>
                    <p class="feature-description">Передавайте показания электросчетчиков в любое время</p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">💧</div>
                    <h3 class="feature-title">Водоснабжение</h3>
                    <p class="feature-description">Учет холодной и горячей воды по показаниям счетчиков</p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">🔥</div>
                    <h3 class="feature-title">Газоснабжение</h3>
                    <p class="feature-description">Контроль расхода газа и своевременная передача данных</p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">📱</div>
                    <h3 class="feature-title">Онлайн-сервис</h3>
                    <p class="feature-description">Доступ к личному кабинету 24/7 с любого устройства</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Инструкции по передаче показаний -->
    <section class="instructions-section">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Как правильно передавать показания</h2>
                <p class="section-subtitle">Пошаговая инструкция для точного учета</p>
            </div>
            
            <div class="instructions-steps">
                <div class="step-card">
                    <div class="step-number">1</div>
                    <div class="step-content">
                        <h3>Снятие показаний</h3>
                        <p>Ежемесячно в период с 20 по 25 число снимите показания со всех счетчиков. Записывайте все цифры до запятой.</p>
                    </div>
                </div>
                
                <div class="step-card">
                    <div class="step-number">2</div>
                    <div class="step-content">
                        <h3>Проверка корректности</h3>
                        <p>Убедитесь, что текущие показания больше предыдущих. Проверьте правильность введенных данных.</p>
                    </div>
                </div>
                
                <div class="step-card">
                    <div class="step-number">3</div>
                    <div class="step-content">
                        <h3>Передача данных</h3>
                        <p>Войдите в личный кабинет и введите показания в соответствующие поля. Нажмите "Передать показания".</p>
                    </div>
                </div>
                
                <div class="step-card">
                    <div class="step-number">4</div>
                    <div class="step-content">
                        <h3>Подтверждение</h3>
                        <p>Дождитесь проверки администратором. Статус передачи можно отслеживать в личном кабинете.</p>
                    </div>
                </div>
            </div>
            
            <div class="tips-grid">
                <div class="tip-card important">
                    <div class="tip-icon">⚠️</div>
                    <div class="tip-content">
                        <h4>Важно!</h4>
                        <p>Показания принимаются строго с 20 по 25 число каждого месяца. Опоздание может привести к начислению по среднему потреблению.</p>
                    </div>
                </div>
                
                <div class="tip-card warning">
                    <div class="tip-icon">📸</div>
                    <div class="tip-content">
                        <h4>Совет</h4>
                        <p>Рекомендуем фотографировать показания счетчиков для подтверждения в случае спорных ситуаций.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Контактная информация -->
    <section class="contacts-section">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Контакты и поддержка</h2>
                <p class="section-subtitle">Мы всегда готовы помочь</p>
            </div>
            
            <div class="contacts-grid">
                <div class="contact-methods">
                    <div class="contact-card">
                        <div class="contact-icon">📞</div>
                        <div class="contact-info">
                            <h4>Телефон горячей линии</h4>
                            <p>8 (800) 555-35-35</p>
                            <span class="contact-hours">Ежедневно с 8:00 до 20:00</span>
                        </div>
                    </div>
                    
                    <div class="contact-card">
                        <div class="contact-icon">✉️</div>
                        <div class="contact-info">
                            <h4>Электронная почта</h4>
                            <p>support@kommunalka-online.ru</p>
                            <span class="contact-hours">Ответ в течение 24 часов</span>
                        </div>
                    </div>
                    
                    <div class="contact-card">
                        <div class="contact-icon">💬</div>
                        <div class="contact-info">
                            <h4>Онлайн-чат</h4>
                            <p>Круглосуточная поддержка</p>
                            <span class="contact-hours">Доступен 24/7 в личном кабинете</span>
                        </div>
                    </div>
                </div>
                
                <div class="support-info">
                    <h3>Центр обслуживания клиентов</h3>
                    <p><strong>Адрес:</strong> г. Москва, ул. Примерная, д. 123</p>
                    <p><strong>Часы работы:</strong> Пн-Пт: 9:00-18:00, Сб: 10:00-16:00</p>
                    <p><strong>Телефон:</strong> +7 (495) 123-45-67</p>
                    
                    <div class="emergency-contacts">
                        <h4>Аварийные службы:</h4>
                        <div class="emergency-grid">
                            <div class="emergency-item">
                                <span class="service-name">Электросети</span>
                                <span class="service-phone">+7 (495) 111-11-11</span>
                            </div>
                            <div class="emergency-item">
                                <span class="service-name">Водоканал</span>
                                <span class="service-phone">+7 (495) 222-22-22</span>
                            </div>
                            <div class="emergency-item">
                                <span class="service-name">Газовая служба</span>
                                <span class="service-phone">+7 (495) 333-33-33</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Новости и объявления -->
    <section class="news-section">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Новости и объявления</h2>
                <p class="section-subtitle">Актуальная информация для абонентов</p>
            </div>
            
            <div class="news-grid">
                <div class="news-card important">
                    <div class="news-badge">Важно</div>
                    <div class="news-date">25.12.2024</div>
                    <h3 class="news-title">График отключений горячей воды</h3>
                    <p class="news-excerpt">С 15 по 30 января 2025 года планируются плановые отключения горячей воды для проведения профилактических работ.</p>
                </div>
                
                <div class="news-card update">
                    <div class="news-badge">Обновление</div>
                    <div class="news-date">20.12.2024</div>
                    <h3 class="news-title">Обновление тарифов с 1 января</h3>
                    <p class="news-excerpt">С 1 января 2025 года вводятся новые тарифы на коммунальные услуги. Подробности в разделе "Тарифы".</p>
                </div>
                
                <div class="news-card deadline">
                    <div class="news-badge">Сроки</div>
                    <div class="news-date">15.12.2024</div>
                    <h3 class="news-title">Срок подачи показаний за декабрь</h3>
                    <p class="news-excerpt">Напоминаем, что показания за декабрь принимаются до 25 декабря включительно.</p>
                </div>
            </div>
            
            <div class="deadline-reminder">
                <div class="reminder-icon">⏰</div>
                <div class="reminder-content">
                    <h3>Ближайший срок подачи показаний</h3>
                    <p class="deadline-date">25 декабря 2024 года</p>
                    <p class="deadline-days">Осталось 5 дней</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Дополнительные разделы -->
    <section class="additional-sections">
        <div class="container">
            <div class="sections-grid">
                <div class="section-card">
                    <div class="section-icon">💰</div>
                    <h3 class="section-card-title">Тарифы</h3>
                    <p class="section-card-description">Актуальные тарифы на все виды коммунальных услуг</p>
                    <?= Html::a('Подробнее →', ['/tariffs'], ['class' => 'section-link']) ?>
                </div>
                
                <div class="section-card">
                    <div class="section-icon">💳</div>
                    <h3 class="section-card-title">Платежи</h3>
                    <p class="section-card-description">Способы оплаты и реквизиты для перечисления</p>
                    <?= Html::a('Подробнее →', ['/payments'], ['class' => 'section-link']) ?>
                </div>
                
                <div class="section-card">
                    <div class="section-icon">📄</div>
                    <h3 class="section-card-title">Документы</h3>
                    <p class="section-card-description">Договоры, нормативные акты и формы заявлений</p>
                    <?= Html::a('Подробнее →', ['/documents'], ['class' => 'section-link']) ?>
                </div>
                
                <div class="section-card">
                    <div class="section-icon">❓</div>
                    <h3 class="section-card-title">Частые вопросы</h3>
                    <p class="section-card-description">Ответы на наиболее часто задаваемые вопросы</p>
                    <?= Html::a('Подробнее →', ['/faq'], ['class' => 'section-link']) ?>
                </div>
            </div>
        </div>
    </section>
</div>
