<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use app\models\CounterReadings; 

$this->title = 'Передача показаний';
$this->params['breadcrumbs'][] = ['label' => 'Мои показания', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$serviceTypes = \app\models\CounterReadings::getServiceTypes();
$serviceIcons = [
    'electricity' => '⚡',
    'gas' => '🔥', 
    'water' => '💧'
];
$serviceUnits = [
    'electricity' => 'кВт·ч',
    'gas' => 'м³',
    'water' => 'м³'
];
?>

<div class="readings-create">
    <div class="readings-header">
        <h1 class="readings-title"><?= Html::encode($this->title) ?></h1>
        <div class="readings-subtitle">Введите текущие показания счетчиков по всем услугам</div>
    </div>

    <div class="readings-form-container">
        <div class="readings-form-card">
            <?php $form = ActiveForm::begin([
                'id' => 'readings-form',
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'form-label'],
                    'inputOptions' => ['class' => 'form-control'],
                    'errorOptions' => ['class' => 'help-block'],
                ],
            ]); ?>

            <div class="form-section">
                <div class="section-header">
                    <div class="section-icon">📅</div>
                    <h3 class="section-title">Дата передачи показаний</h3>
                </div>
                <div class="date-input-container">
                    <?= $form->field($models['electricity'], 'date')->textInput([
                        'type' => 'date',
                        'class' => 'form-control date-input',
                        'value' => date('Y-m-d')
                    ])->label('Дата передачи') ?>
                    <div class="date-hint">Показания передаются на текущую дату</div>
                </div>
            </div>

            <div class="form-section">
                <div class="section-header">
                    <div class="section-icon">🔢</div>
                    <h3 class="section-title">Показания счетчиков</h3>
                </div>
                
                <div class="services-grid">
                    <?php foreach ($models as $type => $model): ?>
                    <div class="service-card" data-service="<?= $type ?>">
                        <div class="service-header">
                            <div class="service-icon"><?= $serviceIcons[$type] ?></div>
                            <h4 class="service-name"><?= $serviceTypes[$type] ?></h4>
                        </div>
                        
                        <div class="readings-comparison">
                            <div class="previous-reading">
                                <span class="reading-label">Предыдущие показания:</span>
                                <span class="reading-value"><?= Yii::$app->formatter->asDecimal($previousReadings[$type], 2) ?></span>
                                <span class="reading-unit"><?= $serviceUnits[$type] ?></span>
                            </div>
                            
                            <div class="current-reading-input">
                                <div class="input-with-arrow">
                                    <div class="arrow">→</div>
                                    <?= $form->field($model, "[$type]current_readings", [
                                        'template' => "
                                            <div class='input-header'>
                                                {label}
                                            </div>
                                            <div class='input-with-unit'>
                                                {input}
                                                <span class='input-unit'>{$serviceUnits[$type]}</span>
                                            </div>
                                            {error}
                                        "
                                    ])->textInput([
                                        'placeholder' => '0.00',
                                        'class' => 'form-control current-readings-input',
                                        'autocomplete' => 'off'
                                    ])->label('Текущие показания') ?>
                                </div>
                            </div>
                        </div>

                        <div class="service-info">
                            <div class="tariff-info">
                                <span class="tariff-label">Тариф:</span>
                                <span class="tariff-value">
                                    <?php 
                                    $tariff = \app\models\Tariff::findOne(['service_type' => $type]);
                                    echo $tariff ? Yii::$app->formatter->asDecimal($tariff->price, 2) . ' руб/' . $serviceUnits[$type] : '—';
                                    ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="form-section submission-section">
                <div class="submission-info">
                    <div class="info-icon">ℹ️</div>
                    <div class="info-content">
                        <h4>Важная информация</h4>
                        <p>Все показания будут проверены администратором. Убедитесь, что текущие показания больше или равны предыдущим.</p>
                    </div>
                </div>

                <div class="form-actions">
                    <?= Html::submitButton('📤 Передать все показания', [
                        'class' => 'btn btn-primary btn-large btn-submit',
                        'data-loading-text' => 'Отправка...'
                    ]) ?>
                    <?= Html::a('↶ Отмена', ['index'], ['class' => 'btn btn-outline btn-cancel']) ?>
                </div>
            </div>

            <?php ActiveForm::end(); ?>
        </div>

        <div class="readings-info-card">
            <div class="info-card-header">
                <div class="info-icon">📊</div>
                <h3>Статистика передачи</h3>
            </div>
            
            <div class="stats-grid">
                <div class="stat-item">
                    <div class="stat-value"><?= CounterReadings::find()->where(['user_id' => Yii::$app->user->id])->count() ?></div>
                    <div class="stat-label">Всего передач</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">
                        <?= CounterReadings::find()
                            ->where(['user_id' => Yii::$app->user->id, 'status' => CounterReadings::STATUS_ACCEPTED])
                            ->count() ?>
                    </div>
                    <div class="stat-label">Принято</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">
                        <?= CounterReadings::find()
                            ->where(['user_id' => Yii::$app->user->id, 'status' => CounterReadings::STATUS_NEW])
                            ->count() ?>
                    </div>
                    <div class="stat-label">На проверке</div>
                </div>
            </div>

            <div class="info-card-header" style="margin-top: 3vh;">
                <div class="info-icon">💰</div>
                <h3>Тарифы</h3>
            </div>
            
            <div class="tariffs-info">
                <?php foreach ($serviceTypes as $type => $name): ?>
                <div class="tariff-item <?= $type === 'electricity' ? 'highlighted' : '' ?>">
                    <div class="tariff-service">
                        <span class="service-icon"><?= $serviceIcons[$type] ?></span>
                        <span><?= $name ?></span>
                    </div>
                    <div class="tariff-price">
                        <?php 
                        $tariff = \app\models\Tariff::findOne(['service_type' => $type]);
                        echo $tariff ? Yii::$app->formatter->asDecimal($tariff->price, 2) . ' руб' : '—';
                        ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="info-footer">
                <p>💡 <strong>Совет:</strong> Регулярно передавайте показания в конце каждого месяца</p>
            </div>
        </div>
    </div>
</div>