<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

$this->title = 'Управление пользователями';
$this->params['breadcrumbs'][] = ['label' => 'Админ-панель', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-container">
    <div class="admin-header">
        <h1 class="admin-title">👥 Управление пользователями</h1>
        <div class="admin-subtitle">Список всех зарегистрированных пользователей системы</div>
    </div>

    <!-- Статистика пользователей -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">👥</div>
            <div class="stat-info">
                <div class="stat-value"><?= $dataProvider->getTotalCount() ?></div>
                <div class="stat-label">Всего пользователей</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">👑</div>
            <div class="stat-info">
                <div class="stat-value">
                    <?= \app\models\User::find()->where(['is_admin' => 1])->count() ?>
                </div>
                <div class="stat-label">Администраторов</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">📊</div>
            <div class="stat-info">
                <div class="stat-value">
                    <?= \app\models\CounterReadings::find()->select('user_id')->distinct()->count() ?>
                </div>
                <div class="stat-label">Активных пользователей</div>
            </div>
        </div>
    </div>

    <?php Pjax::begin(['timeout' => 5000]); ?>
    
    <div class="admin-table-container">
        <div class="table-header-section">
            <h3 class="table-title">📋 Список пользователей</h3>
            <div class="table-actions">
                <div class="filter-info">
                    Показано <?= $dataProvider->getCount() ?> из <?= $dataProvider->getTotalCount() ?> пользователей
                </div>
            </div>
        </div>

        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'tableOptions' => ['class' => 'table admin-table'],
            'layout' => "{items}\n<div class='table-footer'>{summary}\n{pager}</div>",
            'summary' => 'Показано <b>{begin}-{end}</b> из <b>{totalCount}</b> пользователей',
            'summaryOptions' => ['class' => 'summary'],
            'pager' => [
                'options' => ['class' => 'pagination'],
                'linkOptions' => ['class' => 'page-link'],
                'activePageCssClass' => 'active',
                'disabledPageCssClass' => 'disabled',
            ],
            'columns' => [
                [
                    'attribute' => 'id',
                    'label' => 'ID',
                    'headerOptions' => ['class' => 'table-header id-header'],
                    'contentOptions' => ['class' => 'table-cell id-cell'],
                ],
                [
                    'attribute' => 'full_name',
                    'label' => '👤 ФИО',
                    'headerOptions' => ['class' => 'table-header name-header'],
                    'contentOptions' => ['class' => 'table-cell name-cell'],
                ],
                [
                    'attribute' => 'email',
                    'label' => '📧 Email',
                    'headerOptions' => ['class' => 'table-header email-header'],
                    'contentOptions' => ['class' => 'table-cell email-cell'],
                ],
                [
                    'attribute' => 'phone',
                    'label' => '📞 Телефон',
                    'headerOptions' => ['class' => 'table-header phone-header'],
                    'contentOptions' => ['class' => 'table-cell phone-cell'],
                ],
                [
                    'attribute' => 'address',
                    'label' => '🏠 Адрес',
                    'headerOptions' => ['class' => 'table-header address-header'],
                    'contentOptions' => ['class' => 'table-cell address-cell'],
                ],
                [
                    'attribute' => 'residents_count',
                    'label' => '👨‍👩‍👧‍👦 Проживает',
                    'headerOptions' => ['class' => 'table-header residents-header'],
                    'contentOptions' => ['class' => 'table-cell residents-cell'],
                ],
                [
                    'attribute' => 'is_admin',
                    'label' => '👑 Роль',
                    'value' => function($model) {
                        return $model->is_admin ? '👑 Администратор' : '👤 Пользователь';
                    },
                    'format' => 'raw',
                    'headerOptions' => ['class' => 'table-header role-header'],
                    'contentOptions' => ['class' => 'table-cell role-cell'],
                ],
                [
                    'attribute' => 'created_at',
                    'label' => '⏰ Регистрация',
                    'format' => 'datetime',
                    'headerOptions' => ['class' => 'table-header created-header'],
                    'contentOptions' => ['class' => 'table-cell created-cell'],
                ],
                [
                    'class' => 'yii\grid\ActionColumn',
                    'header' => 'Действия',
                    'template' => '{readings} {view}',
                    'headerOptions' => ['class' => 'table-header actions-header'],
                    'contentOptions' => ['class' => 'table-cell actions-cell'],
                    'buttons' => [
                        'readings' => function ($url, $model, $key) {
                            return Html::a('📊', ['user-readings', 'userId' => $model->id], [
                                'class' => 'btn-action view',
                                'title' => 'Показания пользователя',
                                'data-pjax' => 0,
                            ]);
                        },
                        'view' => function ($url, $model, $key) {
                            return Html::a('👁️', ['#'], [
                                'class' => 'btn-action view',
                                'title' => 'Просмотр профиля',
                                'data-pjax' => 0,
                            ]);
                        },
                    ],
                ],
            ],
            'rowOptions' => function($model) {
                return [
                    'class' => 'table-row' . ($model->is_admin ? ' admin-row' : ''),
                    'data-id' => $model->id
                ];
            },
        ]); ?>
    </div>
    
    <?php Pjax::end(); ?>

    <div class="quick-actions">
        <h3 class="actions-title">Быстрые действия</h3>
        <div class="actions-grid">
            <?= Html::a('📊 Все показания', ['index'], ['class' => 'action-btn stats']) ?>
            <?= Html::a('💰 Управление тарифами', ['tariffs'], ['class' => 'action-btn tariffs']) ?>
            <?= Html::a('🛠️ Админ-панель', ['index'], ['class' => 'action-btn']) ?>
        </div>
    </div>
</div>

<?php
$this->registerCssFile('@web/css/admin.css');
?>