<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

$this->title = 'Показания пользователя: ' . $user->full_name;
$this->params['breadcrumbs'][] = ['label' => 'Админ-панель', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => 'Управление пользователями', 'url' => ['users']];
$this->params['breadcrumbs'][] = $this->title;

$serviceIcons = [
    'electricity' => '⚡',
    'gas' => '🔥', 
    'water' => '💧'
];

$statusColors = [
    'new' => 'status-new',
    'accepted' => 'status-accepted',
    'rejected' => 'status-rejected',
];

$statusIcons = [
    'new' => '⏳',
    'accepted' => '✅',
    'rejected' => '❌'
];
?>

<div class="admin-container">
    <div class="admin-header">
        <h1 class="admin-title">📊 Показания пользователя</h1>
        <div class="admin-subtitle"><?= Html::encode($user->full_name) ?></div>
    </div>

    <!-- Информация о пользователе -->
    <div class="detail-card">
        <div class="detail-card-header">
            <h2 class="detail-card-title">👤 Информация о пользователе</h2>
        </div>
        
        <div class="detail-card-body">
            <div class="info-grid">
                <div class="info-section">
                    <div class="info-row">
                        <span class="info-label">ФИО:</span>
                        <span class="info-value"><?= Html::encode($user->full_name) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Email:</span>
                        <span class="info-value"><?= Html::encode($user->email) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Телефон:</span>
                        <span class="info-value"><?= Html::encode($user->phone) ?></span>
                    </div>
                </div>

                <div class="info-section">
                    <div class="info-row">
                        <span class="info-label">Адрес:</span>
                        <span class="info-value"><?= Html::encode($user->address) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Проживает:</span>
                        <span class="info-value"><?= $user->residents_count ?> чел.</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Роль:</span>
                        <span class="info-value"><?= $user->is_admin ? '👑 Администратор' : '👤 Пользователь' ?></span>
                    </div>
                </div>

                <div class="info-section">
                    <div class="info-row">
                        <span class="info-label">Зарегистрирован:</span>
                        <span class="info-value"><?= Yii::$app->formatter->asDatetime($user->created_at) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Всего показаний:</span>
                        <span class="info-value highlight"><?= $dataProvider->getTotalCount() ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php Pjax::begin(['timeout' => 5000]); ?>
    
    <div class="admin-table-container">
        <div class="table-header-section">
            <h3 class="table-title">📋 История показаний</h3>
            <div class="table-actions">
                <div class="filter-info">
                    Показано <?= $dataProvider->getCount() ?> из <?= $dataProvider->getTotalCount() ?> записей
                </div>
            </div>
        </div>

        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'tableOptions' => ['class' => 'table admin-table'],
            'layout' => "{items}\n<div class='table-footer'>{summary}\n{pager}</div>",
            'summary' => 'Показано <b>{begin}-{end}</b> из <b>{totalCount}</b> записей',
            'summaryOptions' => ['class' => 'summary'],
            'pager' => [
                'options' => ['class' => 'pagination'],
                'linkOptions' => ['class' => 'page-link'],
                'activePageCssClass' => 'active',
                'disabledPageCssClass' => 'disabled',
            ],
            'columns' => [
                [
                    'attribute' => 'date',
                    'label' => '📅 Дата',
                    'format' => 'date',
                    'headerOptions' => ['class' => 'table-header date-header'],
                    'contentOptions' => ['class' => 'table-cell date-cell'],
                ],
                [
                    'attribute' => 'service_type',
                    'label' => 'Услуга',
                    'value' => function($model) use ($serviceIcons) {
                        return $serviceIcons[$model->service_type] . ' ' . $model->getServiceTypeLabel();
                    },
                    'format' => 'raw',
                    'headerOptions' => ['class' => 'table-header service-header'],
                    'contentOptions' => ['class' => 'table-cell service-cell'],
                ],
                [
                    'attribute' => 'previous_readings',
                    'label' => '📊 Предыдущие',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->previous_readings, 2);
                    },
                    'headerOptions' => ['class' => 'table-header readings-header'],
                    'contentOptions' => ['class' => 'table-cell readings-cell'],
                ],
                [
                    'attribute' => 'current_readings',
                    'label' => '📈 Текущие',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->current_readings, 2);
                    },
                    'headerOptions' => ['class' => 'table-header readings-header'],
                    'contentOptions' => ['class' => 'table-cell readings-cell current-reading'],
                ],
                [
                    'attribute' => 'consumption',
                    'label' => '📉 Расход',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->consumption, 2);
                    },
                    'headerOptions' => ['class' => 'table-header consumption-header'],
                    'contentOptions' => ['class' => 'table-cell consumption-cell'],
                ],
                [
                    'attribute' => 'sum',
                    'label' => '💳 Сумма',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->sum, 2) . ' руб';
                    },
                    'headerOptions' => ['class' => 'table-header sum-header'],
                    'contentOptions' => ['class' => 'table-cell sum-cell'],
                ],
                [
                    'attribute' => 'status',
                    'label' => '📋 Статус',
                    'value' => function($model) use ($statusIcons, $statusColors) {
                        return Html::tag('span', 
                            $statusIcons[$model->status] . ' ' . $model->getStatusLabel(), 
                            ['class' => "status {$statusColors[$model->status]}"]
                        );
                    },
                    'format' => 'raw',
                    'headerOptions' => ['class' => 'table-header status-header'],
                    'contentOptions' => ['class' => 'table-cell status-cell'],
                ],
                [
                    'class' => 'yii\grid\ActionColumn',
                    'header' => 'Действия',
                    'template' => '{view} {accept} {reject}',
                    'headerOptions' => ['class' => 'table-header actions-header'],
                    'contentOptions' => ['class' => 'table-cell actions-cell'],
                    'buttons' => [
                        'view' => function ($url, $model, $key) {
                            return Html::a('👁️', ['reading-detail', 'id' => $model->id], [
                                'class' => 'btn-action view',
                                'title' => 'Просмотр деталей',
                                'data-pjax' => 0,
                            ]);
                        },
                        'accept' => function ($url, $model, $key) {
                            if ($model->status === 'new') {
                                return Html::a('✅', ['update-status', 'id' => $model->id, 'status' => 'accepted'], [
                                    'class' => 'btn-action accept',
                                    'title' => 'Принять показания',
                                    'data' => [
                                        'confirm' => 'Вы уверены, что хотите принять эти показания?',
                                        'method' => 'post',
                                    ],
                                ]);
                            }
                            return '';
                        },
                        'reject' => function ($url, $model, $key) {
                            if ($model->status === 'new') {
                                return Html::a('❌', ['update-status', 'id' => $model->id, 'status' => 'rejected'], [
                                    'class' => 'btn-action reject',
                                    'title' => 'Отклонить показания',
                                    'data' => [
                                        'confirm' => 'Вы уверены, что хотите отклонить эти показания?',
                                        'method' => 'post',
                                    ],
                                ]);
                            }
                            return '';
                        },
                    ],
                ],
            ],
            'rowOptions' => function($model) use ($statusColors) {
                return [
                    'class' => 'table-row ' . $statusColors[$model->status],
                    'data-id' => $model->id
                ];
            },
        ]); ?>
    </div>
    
    <?php Pjax::end(); ?>

    <div class="form-actions">
        <?= Html::a('👥 К списку пользователей', ['users'], ['class' => 'btn btn-outline']) ?>
        <?= Html::a('📊 Все показания', ['index'], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('🛠️ Админ-панель', ['index'], ['class' => 'btn btn-primary']) ?>
    </div>
</div>

<?php
$this->registerCssFile('@web/css/admin.css');
?>