<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

$this->title = 'Управление тарифами';
$this->params['breadcrumbs'][] = ['label' => 'Админ-панель', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$serviceTypes = \app\models\CounterReadings::getServiceTypes();
$serviceIcons = [
    'electricity' => '⚡',
    'gas' => '🔥', 
    'water' => '💧'
];
?>

<div class="admin-container">
    <div class="admin-header">
        <h1 class="admin-title">💰 Управление тарифами</h1>
        <div class="admin-subtitle">Редактирование тарифов на коммунальные услуги</div>
    </div>

    <!-- Форма добавления нового тарифа -->
    <div class="admin-form">
        <h3 class="table-title">➕ Добавить новый тариф</h3>
        
        <?php $form = ActiveForm::begin([
            'id' => 'tariff-form',
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'form-label'],
                'inputOptions' => ['class' => 'form-control'],
                'errorOptions' => ['class' => 'help-block'],
            ],
        ]); ?>

        <div class="form-group">
            <?= $form->field($model, 'service_type')->dropDownList(
                $serviceTypes,
                [
                    'class' => 'form-control',
                    'prompt' => 'Выберите тип услуги...'
                ]
            ) ?>
        </div>

        <div class="form-group">
            <?= $form->field($model, 'price')->textInput([
                'placeholder' => '0.00',
                'type' => 'number',
                'step' => '0.01',
                'min' => '0'
            ]) ?>
        </div>

        <div class="form-group">
            <?= $form->field($model, 'description')->textarea([
                'placeholder' => 'Описание тарифа...',
                'rows' => 3
            ]) ?>
        </div>

        <div class="form-actions">
            <?= Html::submitButton('💾 Сохранить тариф', ['class' => 'btn btn-primary']) ?>
            <?= Html::a('↶ Отмена', ['tariffs'], ['class' => 'btn btn-outline']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>

    <!-- Список существующих тарифов -->
    <div class="table-header-section">
        <h3 class="table-title">📋 Текущие тарифы</h3>
        <div class="table-actions">
            <div class="filter-info">
                Всего тарифов: <?= count($tariffs) ?>
            </div>
        </div>
    </div>

    <?php if (empty($tariffs)): ?>
        <div class="empty-state">
            <div class="empty-icon">💰</div>
            <h3 class="empty-title">Тарифы не найдены</h3>
            <p class="empty-description">Добавьте первый тариф для начала работы</p>
        </div>
    <?php else: ?>
        <div class="tariffs-grid">
            <?php foreach ($tariffs as $tariff): ?>
            <div class="tariff-card">
                <div class="tariff-header">
                    <div class="tariff-icon"><?= $serviceIcons[$tariff->service_type] ?? '💰' ?></div>
                    <h4 class="tariff-name"><?= $serviceTypes[$tariff->service_type] ?? $tariff->service_type ?></h4>
                </div>
                
                <div class="tariff-price">
                    <?= Yii::$app->formatter->asDecimal($tariff->price, 2) ?> руб.
                </div>
                
                <?php if ($tariff->description): ?>
                <div class="tariff-description">
                    <?= Html::encode($tariff->description) ?>
                </div>
                <?php endif; ?>
                
                <div class="tariff-actions">
                    <?= Html::a('✏️', ['update-tariff', 'id' => $tariff->id], [
                        'class' => 'btn-action edit',
                        'title' => 'Редактировать тариф'
                    ]) ?>
                    
                    <?= Html::a('🗑️', ['delete-tariff', 'id' => $tariff->id], [
                        'class' => 'btn-action delete',
                        'title' => 'Удалить тариф',
                        'data' => [
                            'confirm' => 'Вы уверены, что хотите удалить этот тариф?',
                            'method' => 'post',
                        ],
                    ]) ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="quick-actions">
        <h3 class="actions-title">Быстрые действия</h3>
        <div class="actions-grid">
            <?= Html::a('📊 Все показания', ['index'], ['class' => 'action-btn stats']) ?>
            <?= Html::a('👥 Управление пользователями', ['users'], ['class' => 'action-btn users']) ?>
            <?= Html::a('🛠️ Админ-панель', ['index'], ['class' => 'action-btn']) ?>
        </div>
    </div>
</div>

<?php
$this->registerCssFile('@web/css/admin.css');
?>