<?php
use yii\helpers\Html;

$this->title = 'Детали показаний #' . $reading->id;
$this->params['breadcrumbs'][] = ['label' => 'Админ-панель', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$serviceIcons = [
    'electricity' => '⚡',
    'gas' => '🔥', 
    'water' => '💧'
];

$statusColors = [
    'new' => 'status-new',
    'accepted' => 'status-accepted',
    'rejected' => 'status-rejected',
];

$statusIcons = [
    'new' => '⏳',
    'accepted' => '✅',
    'rejected' => '❌'
];
?>

<div class="admin-container">
    <div class="admin-header">
        <h1 class="admin-title">📋 Детали показаний #<?= $reading->id ?></h1>
        <div class="admin-subtitle">Полная информация о переданных показаниях</div>
    </div>

    <div class="detail-card">
        <div class="detail-card-header">
            <h2 class="detail-card-title">Основная информация</h2>
            <div class="status <?= $statusColors[$reading->status] ?>">
                <?= $statusIcons[$reading->status] ?> <?= $reading->getStatusLabel() ?>
            </div>
        </div>
        
        <div class="detail-card-body">
            <div class="info-grid">
                <div class="info-section">
                    <h3 class="info-section-title">👤 Информация о пользователе</h3>
                    <div class="info-row">
                        <span class="info-label">ФИО:</span>
                        <span class="info-value"><?= Html::encode($reading->user->full_name) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Email:</span>
                        <span class="info-value"><?= Html::encode($reading->user->email) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Телефон:</span>
                        <span class="info-value"><?= Html::encode($reading->user->phone) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Адрес:</span>
                        <span class="info-value"><?= Html::encode($reading->user->address) ?></span>
                    </div>
                </div>

                <div class="info-section">
                    <h3 class="info-section-title">📊 Показания счетчиков</h3>
                    <div class="info-row">
                        <span class="info-label">Услуга:</span>
                        <span class="info-value">
                            <?= $serviceIcons[$reading->service_type] ?> <?= $reading->getServiceTypeLabel() ?>
                        </span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Дата передачи:</span>
                        <span class="info-value"><?= Yii::$app->formatter->asDate($reading->date) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Предыдущие показания:</span>
                        <span class="info-value"><?= Yii::$app->formatter->asDecimal($reading->previous_readings, 2) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Текущие показания:</span>
                        <span class="info-value highlight"><?= Yii::$app->formatter->asDecimal($reading->current_readings, 2) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Расход:</span>
                        <span class="info-value highlight"><?= Yii::$app->formatter->asDecimal($reading->consumption, 2) ?></span>
                    </div>
                </div>

                <div class="info-section">
                    <h3 class="info-section-title">💰 Финансовая информация</h3>
                    <div class="info-row">
                        <span class="info-label">Тариф:</span>
                        <span class="info-value"><?= Yii::$app->formatter->asDecimal($reading->tariff, 2) ?> руб.</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Сумма к оплате:</span>
                        <span class="info-value highlight"><?= Yii::$app->formatter->asDecimal($reading->sum, 2) ?> руб.</span>
                    </div>
                </div>

                <div class="info-section">
                    <h3 class="info-section-title">⏰ Системная информация</h3>
                    <div class="info-row">
                        <span class="info-label">Создано:</span>
                        <span class="info-value"><?= Yii::$app->formatter->asDatetime($reading->created_at) ?></span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Обновлено:</span>
                        <span class="info-value"><?= Yii::$app->formatter->asDatetime($reading->updated_at) ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="form-actions">
        <?php if ($reading->status === 'new'): ?>
            <?= Html::a('✅ Принять показания', 
                ['update-status', 'id' => $reading->id, 'status' => 'accepted'], 
                [
                    'class' => 'btn btn-success',
                    'data' => [
                        'confirm' => 'Вы уверены, что хотите принять эти показания?',
                        'method' => 'post',
                    ],
                ]
            ) ?>
            
            <?= Html::a('❌ Отклонить показания', 
                ['update-status', 'id' => $reading->id, 'status' => 'rejected'], 
                [
                    'class' => 'btn btn-danger',
                    'data' => [
                        'confirm' => 'Вы уверены, что хотите отклонить эти показания?',
                        'method' => 'post',
                    ],
                ]
            ) ?>
        <?php endif; ?>
        
        <?= Html::a('📋 К списку показаний', ['index'], ['class' => 'btn btn-outline']) ?>
        <?= Html::a('👤 Показания пользователя', ['user-readings', 'userId' => $reading->user_id], ['class' => 'btn btn-primary']) ?>
    </div>
</div>
