<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%counter_readings}}`.
 */
class m251029_142724_create_counter_readings_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%counter_readings}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'date' => $this->date()->notNull(),
            'service_type' => $this->string(50)->notNull(),
            'current_readings' => $this->decimal(10, 2)->notNull(),
            'previous_readings' => $this->decimal(10, 2)->notNull(),
            'consumption' => $this->decimal(10, 2)->notNull(),
            'tariff' => $this->decimal(10, 2)->notNull(),
            'sum' => $this->decimal(10, 2)->notNull(),
            'status' => $this->string(20)->defaultValue('new'),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

         $this->addForeignKey(
            'fk-counter_readings-user_id',
            '{{%counter_readings}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%counter_readings}}');
        $this->dropForeignKey('fk-counter_readings-user_id', '{{%counter_readings}}');
    }
}
