<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use app\models\CounterReadings;
use app\models\Tariff;

class ReadingsController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => CounterReadings::find()->where(['user_id' => Yii::$app->user->id]),
            'sort' => ['defaultOrder' => ['date' => SORT_DESC]],
            'pagination' => [
                'pageSize' => 12,
            ],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionCreate()
    {
        $models = [];
        $serviceTypes = CounterReadings::getServiceTypes();
        
        // Создаем модели для каждой услуги
        foreach ($serviceTypes as $type => $name) {
            $model = new CounterReadings();
            $model->user_id = Yii::$app->user->id;
            $model->date = date('Y-m-d');
            $model->service_type = $type;
            $models[$type] = $model;
        }

        // Получаем предыдущие показания для отображения
        $previousReadings = [];
        foreach ($serviceTypes as $type => $name) {
            $lastReading = CounterReadings::find()
                ->where(['user_id' => Yii::$app->user->id, 'service_type' => $type])
                ->orderBy(['date' => SORT_DESC])
                ->one();
                
            $previousReadings[$type] = $lastReading ? $lastReading->current_readings : 0;
        }

        if (Yii::$app->request->isPost) {
            $hasErrors = false;
            $savedCount = 0;
            $postData = Yii::$app->request->post();
            
            foreach ($models as $type => $model) {
                // Правильная загрузка данных для каждой модели
                if (isset($postData['CounterReadings'][$type])) {
                    $modelData = $postData['CounterReadings'][$type];
                    $model->current_readings = $modelData['current_readings'] ?? null;
                    $model->user_id = Yii::$app->user->id;
                    $model->date = date('Y-m-d');
                    $model->service_type = $type;
                    
                    if (!empty($model->current_readings) && $model->validate()) {
                        if ($model->save()) {
                            $savedCount++;
                        } else {
                            $hasErrors = true;
                            Yii::error("Ошибка сохранения для услуги $type: " . print_r($model->errors, true));
                        }
                    }
                }
            }
            
            if (!$hasErrors && $savedCount > 0) {
                Yii::$app->session->setFlash('success', "Показания успешно переданы для {$savedCount} услуг и отправлены на проверку.");
                return $this->redirect(['index']);
            } elseif ($hasErrors) {
                Yii::$app->session->setFlash('error', 'Произошли ошибки при сохранении некоторых показаний.');
            } elseif ($savedCount === 0) {
                Yii::$app->session->setFlash('warning', 'Не передано ни одного показания. Пожалуйста, введите данные.');
            }
        }

        return $this->render('create', [
            'models' => $models,
            'previousReadings' => $previousReadings,
        ]);
    }
}