<?php
// controllers/ProfileController.php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\User;

class ProfileController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $model = User::findOne(Yii::$app->user->id);
        
        return $this->render('index', [
            'model' => $model,
        ]);
    }

    public function actionUpdate()
    {
        $model = User::findOne(Yii::$app->user->id);
        $model->scenario = User::SCENARIO_UPDATE;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Профиль успешно обновлен.');
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    public function actionChangePassword()
    {
        $model = User::findOne(Yii::$app->user->id);
        $model->scenario = User::SCENARIO_CHANGE_PASSWORD;

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            try {
                // Прямое сохранение пароля
                $model->password = Yii::$app->security->generatePasswordHash($model->new_password);
                if ($model->save(false)) {
                    Yii::$app->session->setFlash('success', 'Пароль успешно изменен.');
                    return $this->redirect(['index']);
                } else {
                    Yii::$app->session->setFlash('error', 'Произошла ошибка при сохранении пароля.');
                }
            } catch (\Exception $e) {
                Yii::$app->session->setFlash('error', 'Ошибка: ' . $e->getMessage());
            }
        }

        return $this->render('change-password', [
            'model' => $model,
        ]);
    }

}